//
//  ShakeAndBreakViewController.m
//  ShakeAndBreak
//
//  Created by Robert Górczyński on 11-07-29.
//

#import "ShakeAndBreakViewController.h"

@implementation ShakeAndBreakViewController
@synthesize motionManager; 
@synthesize imageView; 
@synthesize fixed; 
@synthesize broken; 

- (void) viewDidLoad { 
    NSString *path = [[NSBundle mainBundle] pathForResource:@"glass" 
                                                     ofType:@"wav"]; 
    AudioServicesCreateSystemSoundID((CFURLRef)[NSURL 
                                                fileURLWithPath:path], &soundID); 
    self.fixed = [UIImage imageNamed:@"home.png"]; 
    self.broken = [UIImage imageNamed:@"homebroken.png"]; 
	
    imageView.image = fixed; 
	
    self.motionManager = [[[CMMotionManager alloc] init] autorelease]; 
    motionManager.accelerometerUpdateInterval = kUpdateInterval; 
    NSOperationQueue *queue = [[[NSOperationQueue alloc] init] autorelease]; 
    [motionManager startAccelerometerUpdatesToQueue:queue 
                                        withHandler:
     ^(CMAccelerometerData *accelerometerData, NSError *error){ 
		 if (error) { 
			 [motionManager stopAccelerometerUpdates]; 
		 } else { 
			 if (!brokenScreenShowing) { 
				 CMAcceleration acceleration = accelerometerData.acceleration; 
				 if (acceleration.x > kAccelerationThreshold 
					 || acceleration.y > kAccelerationThreshold 
					 || acceleration.z > kAccelerationThreshold) { 
					 [imageView performSelectorOnMainThread:@selector(setImage:) 
												 withObject:broken 
											  waitUntilDone:NO]; 
					 AudioServicesPlaySystemSound(soundID); 
					 brokenScreenShowing = YES; 
				 } 
			 } 
		 } 
	 }]; 
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.motionManager = nil; 
    self.imageView = nil; 
    self.fixed = nil; 
    self.broken = nil; 
    [super viewDidUnload]; 	
}


- (void)dealloc {
    [motionManager release]; 
    [imageView release]; 
    [fixed release]; 
    [broken release]; 	
    [super dealloc];
}

#pragma mark - 
- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event { 
    imageView.image = fixed; 
    brokenScreenShowing = NO; 
} 

@end
